// ImageDeinterlacerDlg.h : header file
//

#if !defined(AFX_IMAGEDEINTERLACERDLG_H__89960B0B_AF9C_43D1_AA56_9EA0D7CBC891__INCLUDED_)
#define AFX_IMAGEDEINTERLACERDLG_H__89960B0B_AF9C_43D1_AA56_9EA0D7CBC891__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "PictureCtrl.h"

#include "ReadOnlyEdit.h"

/////////////////////////////////////////////////////////////////////////////
// CImageDeinterlacerDlg dialog

class CImageDeinterlacerDlg : public CDialog
{
// Construction
public:
	CImageDeinterlacerDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CImageDeinterlacerDlg)
	enum { IDD = IDD_IMAGEDEINTERLACER_DIALOG };
	CPictureCtrl	m_scDestImgPreview;
	CListBox	m_listDestImage;
	CReadOnlyEdit	m_editMessage;
	CString	m_strDstFolderPath;
	CPictureCtrl	m_scImgPrevew;
	CButton	m_btnStop;
	CButton	m_btnConvert;
	CButton   m_btnBlending;
	CButton   m_btnMotionAdapter;
	CButton   m_btnTriangleFiltering;
	CListBox	m_listSrcImage;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CImageDeinterlacerDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CImageDeinterlacerDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnDestroy();
	afx_msg void OnBtnAdd();
	afx_msg void OnBtnRemove();
	afx_msg void OnBtnRemoveAll();	
	afx_msg void OnSelchangeListSourceImage();
	afx_msg void OnBtnDstfolder();
	afx_msg void OnBtnConvert();
	afx_msg void OnBtnStop();
	afx_msg void OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct);
	afx_msg void OnSelchangeListDestinationImage();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:

	BOOL m_bStop;	

	HANDLE hConvertThread;

	DWORD dwConvertThreadId;

	CString GetWorkingPath();

	BOOL LoadImageToStream(CString szFilePath);	

	static DWORD WINAPI ConvertThreadFunc( LPVOID lpParam );

	BOOL ippiRGBToYUV422(BYTE * pSrcFrameBuffer, ULONG nSrcFrameWidth, ULONG nSrcFrameHeight,  ULONG nBitDepth, BYTE * pDstStreamBuffer, ULONG * pDstStreamBufferSize );

	BOOL ImageDeinterlace(BYTE * pSrcFrameBuffer, ULONG nSrcFrameWidth, ULONG nSrcFrameHeight, ULONG nDstStreamBufferSize);

	BOOL YUV422toRGB(ULONG nSrcFrameWidth, ULONG nSrcFrameHeight, ULONG nBitDepth, BYTE * pInputFrameBuffer, BYTE * pOutputFrameBuffer );	

	BOOL WriteToFile(CString strOutputFile, ULONG nSrcFrameWidth, ULONG nSrcFrameHeight, ULONG nBitDepth);

	void UpdateUI();

private:

	DEVICE_HANDLE		m_hDeinterlaceVideoDev;

	BYTE *				m_pYUVFrameBuffer;

	BYTE *				m_pYUVFrameBufferTemp;

	BYTE *				m_pRGBFrameBuffer;

	ULONG				m_nDstStreamBufferSize;

	BITMAPINFOHEADER	m_video_bitmap_info_header;

	// Internal image stream buffer
	//
    IStream*			m_pStream; 

	// Frees the image data
	//
    void FreeData(); 

	CString				m_strBrowseSourceFilePath;	

	CString				m_strOutputDirectory;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_IMAGEDEINTERLACERDLG_H__89960B0B_AF9C_43D1_AA56_9EA0D7CBC891__INCLUDED_)
